/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.gui.boxes.BoxRegistry;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;

public class ExpandPart
implements Part {
    private List<Item> items = new ArrayList<Item>();
    private Settings settings = new Settings(ExpandPart.class);

    public ExpandPart() {
    }

    public ExpandPart(String title, Part child) {
        this.add(title, child);
    }

    public void add(Box box) {
        if (!box.isEnabled() || !box.isActive()) {
            return;
        }
        this.items.add(new Item(box.getName(), box, BoxRegistry.getHeight(box)));
    }

    public void add(String title, Part child) {
        this.items.add(new Item(title, child));
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        ExpandBar bar = new ExpandBar(parent, 512);
        bar.setSpacing(5);
        bar.setLayoutData((Object)new GridData(1808));
        for (int i = 0; i < this.items.size(); ++i) {
            final Item ei = this.items.get(i);
            try {
                Composite composite = new Composite((Composite)bar, 0);
                GridLayout layout = new GridLayout();
                layout.marginLeft = 10;
                layout.marginBottom = 0;
                layout.marginRight = 0;
                layout.marginTop = 0;
                layout.verticalSpacing = 2;
                layout.horizontalSpacing = 0;
                composite.setLayout((Layout)layout);
                ei.part.paint(composite);
                final ExpandItem item = new ExpandItem(bar, 0);
                item.setText(ei.title);
                item.setHeight(ei.height > 0 ? ei.height : composite.computeSize((int)-1, (int)-1).y);
                item.setControl((Control)composite);
                item.setExpanded(this.settings.getBoolean(ei.part.getClass().getName() + ".expanded", true));
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        try {
                            ExpandPart.this.settings.setAttribute(ei.part.getClass().getName() + ".expanded", item.getExpanded());
                        }
                        catch (Exception e2) {
                            Logger.error((String)("unable to store expanded state for child " + ei.part.getClass().getName()), (Throwable)e2);
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                Logger.error((String)("unable to paint box " + ei.title), (Throwable)e);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Anzeigen der Box \"{0}\"", ei.title), 1));
            }
        }
    }

    private class Item {
        private String title = null;
        private Part part = null;
        private int height = -1;

        private Item(String title, Part part) {
            this(title, part, -1);
        }

        private Item(String title, Part part, int height) {
            this.title = title == null ? "" : title;
            this.part = part;
            this.height = height;
        }
    }
}

